<?php
	require_once('session.php');
	require_once('dbconfig.php');
	
	//Time & Date
	date_default_timezone_set ("Africa/Lagos");
	$DATE_NOW 			= date("D d M Y");
	$TIME_NOW 			= date("h:i:s A", time()); // 12:45:00 AM
	$datetimeFormat 	= 'D d M Y h:i:s A';
	
	//Login Token
	$email_token = openssl_random_pseudo_bytes(5);
	$token 			   = bin2hex($email_token);
	
	
	//Temperory Password
	$temp_password 	   = mt_rand(1, 99999);
	
	//Rand Numbers
	$rand 		 		= mt_rand(1, 99999)."-".mt_rand(1, 99999)."-".mt_rand(1, 99999);
	$rand_t 		 	= mt_rand(1, 999)."-".mt_rand(1, 999)."-".mt_rand(1, 999)."-".mt_rand(1, 999);
	
	//Saved Admin Session Details
	$SESS_ID_ADMIN				  =	$_SESSION['SESS_ID_ADMIN'];
	$SESS_FULLNAME_ADMIN		  = $_SESSION['SESS_FULLNAME_ADMIN'];
	$SESS_EMAIL_ADMIN			  =	$_SESSION['SESS_EMAIL_ADMIN'];
	$SESS_USERNAME_ADMIN		  =	$_SESSION['SESS_USERNAME_ADMIN'];
	$SESS_PASSWORD_ADMIN		  =	$_SESSION['SESS_PASSWORD_ADMIN'];
	$SESS_PHOTO_ADMIN			  =	$_SESSION['SESS_PHOTO_ADMIN'];
	$SESS_REGISTRATION_DATE_ADMIN =	$_SESSION['SESS_REGISTRATION_DATE_ADMIN'];
	$SESS_ACCESS_LEVEL_ADMIN	  =	$_SESSION['SESS_ACCESS_LEVEL_ADMIN'];
	$SESS_HASH_ADMIN			  =	$_SESSION['SESS_HASH_ADMIN'];
	$SESS_STATUS_ADMIN			  = $_SESSION['SESS_STATUS_ADMIN'];
	$SESS_TOKEN_ADMIN			  =	$_SESSION['SESS_TOKEN_ADMIN'];
	
	
	//Saved User Session Details
	$SESS_ID_USER			  	  = $_SESSION['SESS_ID'];
	$SESS_PROFILE_PIC_USER  	  = $_SESSION['SESS_PROFILE_PIC'];
	$SESS_FULLNAME_USER  		  = $_SESSION['SESS_FULLNAME'];
	$SESS_EMAIL_USER 			  = $_SESSION['SESS_EMAIL'];
	$SESS_PASSWORD_USER 	 	  = $_SESSION['SESS_PASSWORD'];
	$SESS_GENDER_USER 	  = $_SESSION['SESS_GENDER'];
	$SESS_CLASS_USER 		  = $_SESSION['SESS_CLASS'];
	$SESS_SUBCLASS_USER 	  = $_SESSION['SESS_SUBCLASS'];
	$SESS_SUBJECT_USER 	  = $_SESSION['SESS_SUBJECT'];
	$SESS_PHONE_USER 			  = $_SESSION['SESS_PHONE'];
	$SESS_COUNTRY_USER 			  = $_SESSION['SESS_COUNTRY'];
	$SESS_REGISTRATION_DATE_USER  = $_SESSION['SESS_REGISTRATION_DATE'];
	$SESS_ACCESS_LEVEL_USER 	  = $_SESSION['SESS_ACCESS_LEVEL'] ;
	$SESS_HASH_USER 			  = $_SESSION['SESS_HASH'];
	$SESS_EMAIL_VERIFIED_USER     = $_SESSION['SESS_EMAIL_VERIFIED'];
	$SESS_STATUS_USER 			  = $_SESSION['SESS_STATUS'];
	$SESS_TOKEN_USER 			  = $_SESSION['SESS_TOKEN'];
    $SESS_TOKEN_USER 			  = $_SESSION['SESS_TOKEN'];
    $SESS_S_TYPE                  = $_SESSION['SESS_S_TYPE'];
    $SESS_TEACHER_USER                  = $_SESSION['SESS_TEACHER'];

	//salt
	$salt = "yOShxX$1$2SQNI4nm0$Ael58";
	
	//human time
	function human_time($ts,$datetimeFormat){
		$date = new \DateTime();
		$date->setTimestamp($ts);
		return $date->format($datetimeFormat);
	}
	
	// PDO Function To Handle Prepared Statements (FOR ALL QUERY)
	function sql($DBH, $query, $params, $return) {
		try {
			// Prepare statement
			$STH = $DBH->prepare($query);
			// Execute statement
			$STH->execute($params);
			// Decide whether to return the rows themselves, or just count the rows
			if ($return == "rows") {
				return $STH->fetchAll();
			}
		  	else if ($return == "count") {
				return $STH->rowCount();
			}else{
				
			}
		}
		catch(PDOException $e) { 
			file_put_contents('PDOErrors.txt', $e->getMessage(), FILE_APPEND); # Errors Log File
		}
	}

        // source/functions.php
        
        // Include your database connection code, such as $DBH
        
        function getStudentData($student_id) {
            global $DBH; // Assuming your database connection is defined in the calling script
        
            // Define and execute a SQL query to retrieve student data by ID
            $query = "SELECT * FROM tbl_user WHERE id = :student_id";
            $params = array(':student_id' => $student_id);
        
            try {
                $stmt = $DBH->prepare($query);
                $stmt->execute($params);
                $student = $stmt->fetch(PDO::FETCH_ASSOC);
        
                // Check if a student with the provided ID was found
                if ($student) {
                    return $student; // Return student data as an associative array
                } else {
                    return false; // Return false if no student found
                }
            } catch (PDOException $e) {
                // Handle any database errors here, or log the error
                file_put_contents('PDOErrors.txt', $e->getMessage(), FILE_APPEND);
                return false;
            }
        }

        // Include this function in your source/function.php file
        function updateStudentData($student_id, $fullname, $email, $gender, $age, $class, $subclass, $phone, $photo_url) {
            global $DBH; // Assuming you have a database connection object
        
            // Construct the SQL query
            $sql = "UPDATE tbl_user 
                    SET fullname = :fullname, email = :email, gender = :gender, age = :age, class = :class, subclass = :subclass, phone = :phone, profile_pic = :photo_url 
                    WHERE id = :student_id";
        
            try {
                $stmt = $DBH->prepare($sql);
        
                // Bind parameters
                $stmt->bindParam(':student_id', $student_id);
                $stmt->bindParam(':fullname', $fullname);
                $stmt->bindParam(':email', $email);
                $stmt->bindParam(':gender', $gender);
                $stmt->bindParam(':age', $age);
                $stmt->bindParam(':class', $class);
                $stmt->bindParam(':subclass', $subclass);
                $stmt->bindParam(':phone', $phone);
                $stmt->bindParam(':photo_url', $photo_url);
        
                // Execute the query
                $stmt->execute();
            } catch (PDOException $e) {
                // Handle the error, log it, or display a user-friendly error message
                // For debugging, you can log the error message to a file as shown in your previous code.
                file_put_contents('PDOErrors.txt', $e->getMessage(), FILE_APPEND);
                // You may also throw an exception or display an error message here.
            }
        }


	
	//Redirect
	function redirect($url) {
		try {
			header("Location: $url");
			exit();
		}
		catch(PDOException $e) { 
			file_put_contents('PDOErrors.txt', $e->getMessage(), FILE_APPEND); # Errors Log File
		}
	}

	//Logout
	function logout($url = "https://bcto.com.ng/portal/admin") {
		try {
			session_unset();
			session_destroy();
			header("Location: https://bcto.com.ng/portal/admin");
			exit();
		}
		catch(PDOException $e) { 
			file_put_contents('PDOErrors.txt', $e->getMessage(), FILE_APPEND); # Errors Log File
		}
	}


?>
